/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.block.crops;

import com.renyigesai.immortalers_delight.init.ImmortalersDelightBlocks;
import com.renyigesai.immortalers_delight.init.ImmortalersDelightItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class PearlipearlStalkBlock
extends HorizontalDirectionalBlock
implements IPlantable,
BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61406_;
    public static final BooleanProperty IS_LEAVES = BooleanProperty.m_61465_((String)"is_leaves");
    public static final BooleanProperty BLOOM = BooleanProperty.m_61465_((String)"bloom");
    public static final VoxelShape AGE_1 = PearlipearlStalkBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final VoxelShape AGE_2 = PearlipearlStalkBlock.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    public static final VoxelShape AGE_3 = PearlipearlStalkBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public PearlipearlStalkBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)IS_LEAVES, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BLOOM, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        int age = (Integer)state.m_61143_((Property)AGE);
        return switch (age) {
            case 1 -> AGE_2;
            case 2 -> AGE_3;
            default -> AGE_1;
        };
    }

    public BlockState getStateForLeave(boolean isLeaves) {
        return (BlockState)this.m_49966_().m_61124_((Property)IS_LEAVES, (Comparable)Boolean.valueOf(isLeaves));
    }

    public void m_213897_(BlockState p_222543_, ServerLevel p_222544_, BlockPos p_222545_, RandomSource p_222546_) {
        if (!p_222543_.m_60710_((LevelReader)p_222544_, p_222545_)) {
            p_222544_.m_46961_(p_222545_, true);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource) {
        if (level.m_46859_(pos.m_7494_())) {
            int i = 1;
            while (level.m_8055_(pos.m_6625_(i)).m_60713_((Block)this)) {
                ++i;
            }
            if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (randomSource.m_188503_(6) == 0 ? 1 : 0) != 0)) {
                this.stalkGrowing(state, level, pos, randomSource, i);
                if (((Boolean)state.m_61143_((Property)BLOOM)).booleanValue()) {
                    Direction direction = (Direction)state.m_61143_((Property)f_54117_);
                    BlockPos neighborPos = pos.m_7495_().m_121945_(direction);
                    if (level.m_8055_(neighborPos).m_60795_()) {
                        BlockState bBlockState = (BlockState)((Block)ImmortalersDelightBlocks.PEARLIPEARL_BUNDLE.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)direction.m_122424_());
                        level.m_46597_(neighborPos, bBlockState);
                    }
                }
            }
        }
    }

    public void stalkGrowing(BlockState state, ServerLevel level, BlockPos pos, RandomSource randomSource, int hight) {
        int age = (Integer)state.m_61143_((Property)AGE);
        if (hight < 3) {
            level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)((Direction)state.m_61143_((Property)f_54117_)))).m_61124_((Property)IS_LEAVES, (Comparable)Boolean.valueOf(true)));
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)IS_LEAVES, (Comparable)Boolean.valueOf(false)), 3);
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos.m_7494_(), (BlockState)this.m_49966_());
        } else if (age < 2) {
            for (int j = 0; j < 3; ++j) {
                boolean b = j != 2 && j != 1;
                int n = (Integer)level.m_8055_(pos.m_6625_(j)).m_61143_((Property)AGE) != 2 ? (Integer)level.m_8055_(pos.m_6625_(j)).m_61143_((Property)AGE) + 1 : 2;
                level.m_7731_(pos.m_6625_(j), (BlockState)((BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(n))).m_61124_((Property)IS_LEAVES, (Comparable)Boolean.valueOf(b)), 3);
            }
        }
        if (hight == 3 && !((Boolean)state.m_61143_((Property)IS_LEAVES)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)IS_LEAVES, (Comparable)Boolean.valueOf(true)), 3);
        }
        if (age == 2 && hight == 3 && ((Boolean)state.m_61143_((Property)IS_LEAVES)).booleanValue()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BLOOM, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public BlockState m_7417_(BlockState p_57179_, Direction p_57180_, BlockState p_57181_, LevelAccessor p_57182_, BlockPos p_57183_, BlockPos p_57184_) {
        if (!p_57179_.m_60710_((LevelReader)p_57182_, p_57183_)) {
            p_57182_.m_186460_(p_57183_, (Block)this, 1);
        }
        return super.m_7417_(p_57179_, p_57180_, p_57181_, p_57182_, p_57183_, p_57184_);
    }

    public boolean m_7898_(BlockState p_57175_, LevelReader p_57176_, BlockPos p_57177_) {
        BlockState soil = p_57176_.m_8055_(p_57177_.m_7495_());
        if (soil.canSustainPlant((BlockGetter)p_57176_, p_57177_.m_7495_(), Direction.UP, (IPlantable)this)) {
            return true;
        }
        BlockState blockstate = p_57176_.m_8055_(p_57177_.m_7495_());
        if (blockstate.m_60713_((Block)this)) {
            return true;
        }
        if (blockstate.m_204336_(BlockTags.f_144274_) || blockstate.m_204336_(BlockTags.f_13029_)) {
            BlockPos blockpos = p_57177_.m_7495_();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockstate1 = p_57176_.m_8055_(blockpos.m_121945_(direction));
                FluidState fluidstate = p_57176_.m_6425_(blockpos.m_121945_(direction));
                if (!p_57175_.canBeHydrated((BlockGetter)p_57176_, p_57177_, fluidstate, blockpos.m_121945_(direction)) && !blockstate1.m_60713_(Blocks.f_50449_)) continue;
                return true;
            }
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.m_21120_(hand).m_150930_((Item)ImmortalersDelightItems.PEARLIP.get())) {
            if (player.m_7500_()) {
                return super.m_6227_(state, level, pos, player, hand, hitResult);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    public boolean m_7370_(LevelReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        boolean canFruit;
        BlockState blockstate = pLevel.m_8055_(pPos.m_7494_());
        BlockState blockstate1 = pLevel.m_8055_(pPos.m_6630_(2));
        boolean bl = canFruit = blockstate.m_60713_((Block)this) && blockstate.m_61143_((Property)IS_LEAVES) == this.getStateForLeave(false).m_61143_((Property)IS_LEAVES) && blockstate1.m_60713_((Block)this) && blockstate1.m_61143_((Property)BLOOM) != this.getStateForLeave(false).m_61143_((Property)IS_LEAVES);
        if (canFruit) {
            return true;
        }
        int i = 1;
        while (pLevel.m_8055_(pPos.m_6625_(i)).m_60713_((Block)this)) {
            ++i;
        }
        boolean canBloom = i == 3 && pLevel.m_8055_(pPos).m_60713_((Block)this) && pState.m_61143_((Property)BLOOM) == this.getStateForLeave(false).m_61143_((Property)IS_LEAVES);
        boolean canGrow = i < 3 && blockstate.m_60795_();
        return canGrow || canBloom;
    }

    public boolean m_214167_(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return !pLevel.m_8055_(pPos.m_7495_()).m_60713_((Block)this) || pRandom.m_188503_(5) < 3;
    }

    public void m_214148_(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        BlockPos blockpos = pPos.m_7494_();
        BlockState blockstate = pLevel.m_8055_(blockpos);
        if (!blockstate.m_60713_((Block)this)) {
            int i = 1;
            while (pLevel.m_8055_(pPos.m_6625_(i)).m_60713_((Block)this)) {
                ++i;
            }
            this.stalkGrowing(pState, pLevel, pPos, pRandom, i);
            return;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            int age;
            BlockPos neighborPos = blockpos.m_121945_(direction);
            BlockState neighborState = pLevel.m_8055_(neighborPos);
            if (neighborState.m_60795_()) {
                BlockState bBlockState = (BlockState)((Block)ImmortalersDelightBlocks.PEARLIPEARL_BUNDLE.get()).m_49966_().m_61124_((Property)f_54117_, (Comparable)direction.m_122424_());
                pLevel.m_46597_(neighborPos, bBlockState);
            }
            if (!neighborState.m_60713_((Block)ImmortalersDelightBlocks.PEARLIPEARL_BUNDLE.get()) || (age = ((Integer)neighborState.m_61143_((Property)AGE)).intValue()) >= 2 || pRandom.m_188503_(4) != 0) continue;
            pLevel.m_7731_(neighborPos, (BlockState)neighborState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            ForgeHooks.onCropsGrowPost((Level)pLevel, (BlockPos)pPos, (BlockState)pState);
        }
    }

    public BlockState m_5573_(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.m_43725_().m_8055_(pContext.m_8083_().m_7495_());
        boolean flag = blockstate.m_60713_((Block)this);
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)(flag ? (Direction)blockstate.m_61143_((Property)f_54117_) : pContext.m_8125_().m_122424_()));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.m_61104_(new Property[]{AGE, IS_LEAVES, BLOOM, f_54117_});
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        return this.m_49966_();
    }
}

